/******************************************************************************		
*                                                                                   	
*       Copyright (C) 2008 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       FLASH_DRV.H               											
*														              					
* Description:	  Flash Header file for MC9S08DZ60	        	    	
*                 based on Specification Rev. 3  	       						
*																						
* Notes:        																		
*  ***********************************************************************  			
*  *  THIS CODE IS ONLY INTENDED AS AN EXAMPLE OF CODE FOR THE           *  	 		
*  *  FREESCALE CW COMPILER AND HAS ONLY BEEN GIVEN A MIMIMUM            *  	 		
*  *  LEVEL OF TEST. IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES         *  	 		
*  *  AND NO PROMISE OF SUPPORT.                                         *  	 		
*  ***********************************************************************  	 		
*																						
* Freescale reserves the right to make changes without further notice to any			
* product herein to improve reliability, function, or design. Freescale does	 		
* not assume any  liability arising  out  of the  application or use of any 	 		
* product,  circuit, or software described herein;  neither  does it convey 	 		
* any license under its patent rights  nor the  rights of others.  Freescale	 		
* products are not designed, intended,  or authorized for use as components 	 		
* in  systems  intended  for  surgical  implant  into  the  body, or  other 	 		
* applications intended to support life, or  for any  other application  in 	 		
* which the failure of the Freescale product  could create a situation where	 		
* personal injury or death may occur. Should Buyer purchase or use Freescale	 		
* products for any such intended  or unauthorized  application, Buyer shall 	 		
* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,	 		
* affiliates,  and distributors harmless against all claims costs, damages, 	  		
* and expenses, and reasonable  attorney  fees arising  out of, directly or 	 		
* indirectly,  any claim of personal injury  or death  associated with such 	 		
* unintended or unauthorized use, even if such claim alleges that  Freescale	 		
* was negligent regarding the  design  or manufacture of the part. Freescale	 		
* and the Freescale logo* are registered trademarks of Freescale Ltd.       	 		
******************************************************************************/		
/******************************************************************************/
#ifndef FLASH_DRV_H        /*prevent duplicated includes*/
#define FLASH_DRV_H

#include "derivative.h"

#define BLANK_CHECK             0x05      /* Flash command options */
#define	BYTE_PROGRAM            0x20
#define BURST_PROGRAM           0x25
#define SECTOR_ERASE            0x40
#define MASS_ERASE              0x41
#define SECTOR_ERASE_ABORT      0x47

#define FLASH_START             0xD000    /* Start address of sector being programmed/erased */

#define FLASH_SECTOR_SIZE       0x0300

#define FLASH_BURST_SIZE        0x0100

#define FLASH_OK                0x00      /* Return messages */
#define FLASH_FACCERR           0x01
#define FLASH_FPVIOL            0x02
#define FLASH_PROG_DATAERR      0x04
#define FLASH_SECTOR_ERASEERR   0x10
#define FLASH_BLANK             0x20
#define SECTOR_ERASED           0x40

#define FLASH_FDIV_20M          FCDIV = 0x4C     /* Value to be written to FCDIV register */

#define FLASH_CMD_MANUAL_ABORT  FSTAT_FCBEF = 0

#define zero      0x30                    /* Cases for function selection */
#define one       0x31
#define two       0x32
#define three     0x33
#define four      0x34
#define five      0x35
#define six       0x36

extern byte Mass_Erase(void);
extern byte Byte_Program(byte *DestPtr, byte *SrcPtr, word Length);
extern byte Blank_Check(void);
extern byte Burst_Program(byte *DestPtr, byte *SrcPtr, word Length);
extern byte Sector_Erase(byte *Addr);
extern byte Sector_Erase_Abort(void);

#endif